#pragma once
#include <unordered_set>
#include <iostream>
#include <list>
#include "Structures.h"
#include <functional>

template<typename T>
void hashCombine(size_t& seed, const T& value) 
{
	seed ^= std::hash<T>()(value) + 0x9e3379b9 + (seed << 6) + (seed >> 2);
}

template<typename T>
void hashValue(size_t& seed, const T& value) 
{
	hashCombine(seed, value);
}

template<typename T, typename...Types>
void hashValue(size_t& seed, const T& value, const Types &...args) 
{
	hashCombine(seed, value);
	hashValue(seed, args...);
}

template<typename ... Types>
size_t hashValue(const Types &...args) 
{
	size_t seed = 0;
	hashValue(seed, args...);
	return seed;
}

struct Hash
{
	size_t operator () (const Edge& edge) const
	{
		if (edge.nodePair.first <= edge.nodePair.second)
		{
			return hashValue(edge.nodePair.first, edge.nodePair.second);
		}
		else
		{
			return hashValue(edge.nodePair.second, edge.nodePair.first);
		}
	}
};